package gov.va.med.mhv.usermgmt.web.controller;

import gov.va.med.mhv.usermgmt.web.formbean.UserProfile;
import gov.va.med.mhv.usermgmt.web.util.WebUtility;

import java.util.Date;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class AccountTypeController extends AbstractController{
	
	private static final long serialVersionUID = -1364879219750578063L;
	private static Logger log = LogManager.getLogger(AccountTypeController.class);
	private String association;
	private String createdDate;
	private String email;
	private String accountType;
	private boolean premium;
	private boolean advanced;
	private boolean basic;
	
	public void init(ComponentSystemEvent event){
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		if(session.getAttribute("LIFERAY_SHARED_userid", PortletSession.APPLICATION_SCOPE) != null){
			accountType = (String) session.getAttribute("LIFERAY_SHARED_accountType", PortletSession.APPLICATION_SCOPE);
			setAccountType(accountType);
		}
		if(session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE) != null){
			Long uid  = (Long) session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
			setDisplayValues(this.userProfileDtoToFormBeanConverter.convert(getUserProfile(uid)));
		}
	}

	private void setDisplayValues(UserProfile userProfile) {
		association =setAssociation(userProfile);
		createdDate=setCreatedDate(userProfile.getCreatedDate());
		email=userProfile.getContact().getEmail();
	}


	private String setCreatedDate(Date createdDate) {
		return  WebUtility.dateToString(createdDate, "MM/dd/yyyy h:mm a z");
	}


	private String setAssociation(UserProfile userProfile) {
		StringBuffer sb = new StringBuffer();
		boolean firstTime = true;
		if (firstTime) {
			sb.append(value(userProfile));
			firstTime = false;
		} else {
			sb.append(",");
			sb.append(value(userProfile));
		}

		return sb.toString();
	}
	
	
	private String value(UserProfile userProfile){
		StringBuffer value= new StringBuffer();
		boolean first=true;
		
		if(Boolean.TRUE.equals(userProfile.getIsPatient())){
			first=false;
			value.append("VA Patient");
		};
		 if(Boolean.TRUE.equals(userProfile.getIsVeteran())){
			    if(!first){
				  value.append(", ");
			    }
				value.append("Veteran");
				first=false;
		 }
		 
		 if(Boolean.TRUE.equals(userProfile.getIsHealthCareProvider())){
			 if(!first){
				   value.append(", ");
			 }
			value.append("Health Care Provider");
			first=false;
		 }
		 
		 if(Boolean.TRUE.equals(userProfile.getIsPatientAdvocate())){
			 if(!first){
			   value.append(", ");
			 }
			 value.append("Veteran Advocate/Family Member/Friend");
			 first=false;
		 }
		
		 if(Boolean.TRUE.equals(userProfile.getIsEmployee())){
		   if(!first){
			  value.append(", ");
		   }
			value.append("VA Employee");
			first=false;
		 }
		 
		 if(Boolean.TRUE.equals(userProfile.getIsChampVABeneficiary())){
		   if(!first){
			  value.append(", ");
		   }
			value.append("CHAMPVA Beneficiary");
			first=false;
		 }
		 if(Boolean.TRUE.equals(userProfile.getIsServiceMember())){
		   if(!first){
			  value.append(", ");
		   }
			value.append("Servicemember");
			first=false;
		 }
		 if(Boolean.TRUE.equals(userProfile.getIsOther())){
			 if(!first){
				   value.append(", ");
			 }
			value.append("Other");
            first=false;
		 }
		return value.toString();
	}

	public String getAssociation() {
		return association;
	}


	public void setAssociation(String association) {
		this.association = association;
	}


	public String getCreatedDate() {
		return createdDate;
	}


	public void setCreatedDate(String createdDate) {
		this.createdDate = createdDate;
	}


	public String getEmail() {
		return email;
	}


	public void setEmail(String email) {
		this.email = email;
	}


	public String getAccountType() {
		return accountType;
	}


	public void setAccountType(String accountType) {
		premium=false;
		advanced=false;
		basic=false;
		if(accountType.equals("Premium")){
			premium=true;
		}else if(accountType.equals("Advanced")){
			advanced=true;
		}else{
			basic=true;
		}
		this.accountType = accountType;
	}


	public boolean isPremium() {
		return premium;
	}


	public void setPremium(boolean premium) {
		this.premium = premium;
	}


	public boolean isAdvanced() {
		return advanced;
	}


	public void setAdvanced(boolean advanced) {
		this.advanced = advanced;
	}


	public boolean isBasic() {
		return basic;
	}


	public void setBasic(boolean basic) {
		this.basic = basic;
	}
	
}
